<?php
namespace AmazonAssociatesLinkBuilder\helper;

use Exception;

class Xml_Cache
{
    private const AALB_CACHE_DIR = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR . 'aalbx' . DIRECTORY_SEPARATOR;
    //private const CACHE_TIME_IN_SECONDS = 18000;
    private const CACHE_TIME_IN_SECONDS = 3600 * 5;

    private function create_dir_if_not_exists(string $directory)
    {
        if (!is_dir($directory)) {
            return mkdir($directory, 0755, true);
        }
        return true;
    }

    private function get_cache_dir_for_marketplace(string $marketplace)
    {
        return self::AALB_CACHE_DIR . $marketplace;
    }

    /**
     * Adds entry in the cache for given asin, marketplace and response.
     *
     * @param array $items_array Array of asin => response pairs
     * @param string $marketplace
     */
    public function add_items($items_array, $marketplace )
    {
        $cache_dir = $this->get_cache_dir_for_marketplace($marketplace);
        $this->create_dir_if_not_exists($cache_dir);
        foreach ($items_array as $asin => $response) {
            $result = file_put_contents($cache_dir . DIRECTORY_SEPARATOR . $asin . '.xml', $response);
            /*echo "<pre>";
            echo "add item $asin:";
            var_dump($result);
            echo "</pre>";*/
        }
    }

    /**
     * @param $asins_array
     * @param $marketplace
     * @return array
     * @throws Exception
     */
    public function lookup_asins_response($asins_array, $marketplace)
    {
        $cache_dir = $this->get_cache_dir_for_marketplace($marketplace);
        $response_items = [];
        foreach ($asins_array as $asin) {
            $cache_file = $cache_dir . DIRECTORY_SEPARATOR . $asin . '.xml';
            /*echo "<pre>";
            echo "is cache not expired:";
            var_dump(is_file($cache_file) && !$this->is_cache_file_expired($cache_file));
            echo "</pre>";*/
            if (is_file($cache_file) && !$this->is_cache_file_expired($cache_file)) {
                /*echo "<pre>";
                echo "cache NOT expired:";
                var_dump($asin);
                echo "</pre>";*/
                $file_contents = file_get_contents($cache_file);
                if (!empty($file_contents)) {
                    //$xml_element = new SimpleXMLElement($file_contents);
                    $response_items[$asin] = $file_contents;
                    //$response_items[$asin] = $xml_element;
                    /*if ($asin === 'B0746N9T2J' || $asin === 'B07Q844492') {
                        echo "<pre>";
                        echo "lookup:";
                        var_dump($xml_element);
                        echo "</pre>";
                    }*/
                }
            } /*else {

                echo "<pre>";
                echo "cache expired:";
                var_dump($asin);
                echo "</pre>";
            }*/
        }
        return $response_items;
    }

    /**
     * Checks if this cache file is expired
     *
     * @param string $cache_file
     * @return bool
     * @throws Exception
     */
    private function is_cache_file_expired(string $cache_file)
    {
        $date = new \DateTime();
        $file_date = new \DateTime();
        $file_date->setTimestamp(filemtime($cache_file));
        $diff = $date->diff($file_date);
        /*echo "<pre>";
        echo "diff:";
        var_dump($diff->s);
        echo "</pre>";
        echo "<pre>";
        echo "base:";
        var_dump(self::CACHE_TIME_IN_SECONDS);
        echo "</pre>";*/
        if ($diff->s > self::CACHE_TIME_IN_SECONDS) {
            return true;
        }
        return false;
    }
}