<?php
/*
Copyright 2016-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.

Licensed under the GNU General Public License as published by the Free Software Foundation,
Version 2.0 (the "License"). You may not use this file except in compliance with the License.
A copy of the License is located in the "license" file accompanying this file.

This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
either express or implied. See the License for the specific language governing permissions
and limitations under the License.
*/

namespace AmazonAssociatesLinkBuilder\constants;

/**
 * Class for Holding Plugin URLs
 *
 * @since      1.8.0
 * @package    AmazonAssociatesLinkBuilder
 * @subpackage AmazonAssociatesLinkBuilder/constants
 */
class Plugin_Urls {
    //Plugin Specific URLs
    const CONDITIONS_OF_USE_URL = 'https://s3.amazonaws.com/aalb-public-resources/documents/AssociatesLinkBuilder-ConditionsOfUse-2017-01-17.pdf';
    const USER_GUIDE_URL = 'https://s3.amazonaws.com/aalb-public-resources/documents/AssociatesLinkBuilder-UserGuide.pdf';
    const SUPPORT_FORUM_URL = 'https://www.linkbuilderforamazonassociates.com';
    //const SUPPORT_FORUM_URL = 'https://wordpress.org/support/plugin/link-builder-for-amazon-associates';

    //Associate URLs
    const GETTING_STARTED_URL = 'http://docs.aws.amazon.com/AWSECommerceService/latest/DG/CHAP_GettingStarted.html';
    const AFFILIATE_WEBSITE_URL = 'https://affiliate-program.amazon.com';
    const ADDING_SECONDARY_USER_AC_URL = 'https://affiliate-program.amazon.com/help/node/topic/202049770';
    const ASSOCIATE_SIGN_UP_URL = 'http://docs.aws.amazon.com/AWSECommerceService/latest/DG/becomingAssociate.html';
    const NEW_PAGE_TARGET = "_blank";
}